<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

use App\Http\Controllers\HomeController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\UserProfileController;
use App\Http\Controllers\ResetPassword;
use App\Http\Controllers\ChangePassword;    
use App\Http\Controllers\EmailCampaignController;    

use App\Models\EmailLog;


Route::get('/', function () {return redirect('/dashboard');})->middleware('auth');
	Route::get('/register', [RegisterController::class, 'create'])->middleware('guest')->name('register');
	Route::post('/register', [RegisterController::class, 'store'])->middleware('guest')->name('register.perform');
	Route::get('/login', [LoginController::class, 'show'])->middleware('guest')->name('login');
	Route::post('/login', [LoginController::class, 'login'])->middleware('guest')->name('login.perform');
	Route::get('/reset-password', [ResetPassword::class, 'show'])->middleware('guest')->name('reset-password');
	Route::post('/reset-password', [ResetPassword::class, 'send'])->middleware('guest')->name('reset.perform');
	Route::get('/change-password', [ChangePassword::class, 'show'])->middleware('guest')->name('change-password');
	Route::post('/change-password', [ChangePassword::class, 'update'])->middleware('guest')->name('change.perform');
	Route::get('/dashboard', [HomeController::class, 'index'])->name('home')->middleware('auth');
Route::group(['middleware' => 'auth'], function () {
	Route::get('/virtual-reality', [PageController::class, 'vr'])->name('virtual-reality');
	Route::get('/rtl', [PageController::class, 'rtl'])->name('rtl');
	Route::get('/profile', [UserProfileController::class, 'show'])->name('profile');
	Route::post('/profile', [UserProfileController::class, 'update'])->name('profile.update');
	Route::get('/profile-static', [PageController::class, 'profile'])->name('profile-static'); 
	Route::get('/sign-in-static', [PageController::class, 'signin'])->name('sign-in-static');
	Route::get('/sign-up-static', [PageController::class, 'signup'])->name('sign-up-static'); 

	Route::get('/form', [EmailCampaignController::class, 'showForm'])->name('email_campaign.form');
Route::post('/upload', [EmailCampaignController::class, 'uploadCsv'])->name('email_campaign.upload');
Route::get('/preview', [EmailCampaignController::class, 'preview'])->name('email_campaign.preview');
Route::post('/send', [EmailCampaignController::class, 'sendCampaign'])->name('email_campaign.send');
Route::get('/result', function(){ return view('email_campaign.result'); })->name('email_campaign.result');
Route::get('/stats', [EmailCampaignController::class, 'stats'])->name('email_campaign.stats');

// Pixel tracking route
Route::get('/track-email/{id}.png', function ($id) {
    $log = EmailLog::find($id);

    // ✅ Mark email as opened (only once)
    if ($log && !$log->opened) {
        $log->opened = true;
        $log->opened_at = now();
        $log->save();
    }

    // ✅ Fetch your external image (visible PNG)
    $imageUrl = 'https://d1oco4z2z1fhwp.cloudfront.net/templates/default/10426/back_to_school.png';
    $imageContent = file_get_contents($imageUrl);

    // ✅ Return the image response
    return Response::make($imageContent, 200, [
        'Content-Type' => 'image/png',
        'Cache-Control' => 'no-cache, no-store, must-revalidate',
        'Pragma' => 'no-cache',
        'Expires' => '0',
    ]);
});
	Route::get('/{page}', [PageController::class, 'index'])->name('page');
	Route::post('logout', [LoginController::class, 'logout'])->name('logout');
});